// Decompiled by Jad v1.5.8g. Copyright 2001 Pavel Kouznetsov.
// Jad home page: http://www.kpdus.com/jad.html
// Decompiler options: packimports(3) braces deadcode 

package net.minecraft.src;

import java.util.List;
import java.util.Random;

// Referenced classes of package net.minecraft.src:
//            EntityCreature, IMob, World, Entity, 
//            AxisAlignedBB, MathHelper, EnumSkyBlock, NBTTagCompound

public class EntityM4DMob extends EntityCreature
    implements IMob
{

    public EntityM4DMob(World world)
    {
        super(world);
        attackStrength = 2;
        health = 1;
        maxHealth = 1;
    }

    public void onLivingUpdate()
    {
    	if (corrupted && ticksExisted%50==0)
    	{
    		double d = worldObj.rand.nextGaussian() * 0.02D;
            double d1 = worldObj.rand.nextGaussian() * 0.02D;
            double d2 = worldObj.rand.nextGaussian() * 0.02D;
            worldObj.spawnParticle("heart", (posX + (double)(worldObj.rand.nextFloat() * width * 2.0F)) - (double)width, posY + 0.5D + (double)(worldObj.rand.nextFloat() * height), (posZ + (double)(worldObj.rand.nextFloat() * width * 2.0F)) - (double)width, d, d1, d2);
    	}
    	if (health>maxHealth)
    	{
    		health=maxHealth;
    	}
    	if(worldObj.isDaytime() && !mod_Mine4Dead.debugMode)
        {
    		value=0;
    		setEntityDead();
        }
        super.onLivingUpdate();
        if (trapped>0)
        {
        	posX=trapX;
        	posZ=trapZ;
        	trapped--;
        }
        if(followerLimit>0 && ticksExisted%300==0)
        {
        	gatherFollowers();
        }
    }
	
	
	public void moveEntity(double d, double d1, double d2)
    {
		if (trapped>0)
		{
			d=0;
			d2=0;
		}
		super.moveEntity(d, d1, d2);
    }
    
    public void moveFlying(float f1, float f2, float f3)
    {
        float f4 = MathHelper.sqrt_float(f1 * f1 + f2 * f2);
        if(f4 < 0.01F)
        {
            return;
        }
        if(f4 < 1.0F)
        {
            f4 = 1.0F;
        }
        f4 = f3 / f4;
        f1 *= f4;
        f2 *= f4;
        float f5 = MathHelper.sin((rotationYaw * 3.141593F) / 180F);
        float f6 = MathHelper.cos((rotationYaw * 3.141593F) / 180F);
        motionX += f1 * f6 - f2 * f5 * mobSpeed;
        motionZ += f2 * f6 + f1 * f5 * mobSpeed; // Speed hook
    }

    public void onUpdate()
    {
        super.onUpdate();
    }
    
    protected void jump()
    {
    	if (trapped>0)
    	{
    		return;
    	}
        motionY = 0.41999998688697815D * jumpPower;
    }

    protected Entity findPlayerToAttack()
    {
    	float f = mod_Mine4Dead.pathComplexity;
    	if (following!=null)
    	{
    		f/=3F;
    	}
    	Entity target = null;
    	if (!corrupted)
    	{
    		target = worldObj.getClosestPlayerToEntity(this,f);
    		if (target!=null && target.isDead)
    		{
    			target=null;
    		}
    	}
    	else
    	{
    		AxisAlignedBB boundingBox = AxisAlignedBB.getBoundingBox(0.0D, 0.0D, 0.0D, 0.0D, 0.0D, 0.0D);
        	List list1 = worldObj.getEntitiesWithinAABBExcludingEntity(this, boundingBox.addCoord(posX, posY, posZ).expand(8.0D, 8.0D, 8.0D));
        	for (int i = 0; i < list1.size(); i++)
        	{
        		if (list1.get(i) instanceof EntityM4DMob && !((EntityM4DMob)list1.get(i)).corrupted)
        		{
        			target = (Entity) list1.get(i);
        		}
        	}
    		
    	}
        return target;
    }

    public boolean attackEntityFrom(Entity entity, int i)
    {
        if(super.attackEntityFrom(entity, i))
        {
            if(riddenByEntity == entity || ridingEntity == entity)
            {
                return true;
            }
            if(entity != this &&
            		!(entity instanceof EntityPlayer && corrupted))
            {
                playerToAttack = entity;
            }
            return true;
        } else
        {
            return false;
        }
    }

    protected void attackEntity(Entity entity, float f)
    {
        if(attackTime <= 0 && f < mobRange && entity.boundingBox.maxY > boundingBox.minY && entity.boundingBox.minY < boundingBox.maxY)
        {
            attackTime = attackInterval;
            entity.attackEntityFrom(this, attackStrength);
            if (fire >=0)
            {
            	entity.fire+=fire/4;
            }
            if (corrupted && worldObj.rand.nextInt(101)<=value)
            {
            	corrupted=false;
            }
        }
    }
    
    public void getNewPath()
    {
    	playerToAttack = findPlayerToAttack();
        if(playerToAttack != null)
        {
            pathToEntity = worldObj.getPathToEntity(this, playerToAttack, mod_Mine4Dead.pathComplexity);
            if (pathToEntity!=null)
            {
            	return;
            }
        }
        if (following!=null)
        {
        	if (following.isDead)
        	{
        		following=null;
        		return;
        	}
        	pathToEntity = worldObj.getPathToEntity(this, following, mod_Mine4Dead.pathComplexity);
        	if (pathToEntity!=null)
            {
            	return;
            }
        }
        int x = mod_Mine4Dead.shrine.xCoord;
        int y = mod_Mine4Dead.shrine.yCoord;
        int z = mod_Mine4Dead.shrine.zCoord;
        pathToEntity = worldObj.getEntityPathToXYZ(this, x, y, z, mod_Mine4Dead.pathComplexity);
        int i = 0;
        while (pathToEntity==null && i < mod_Mine4Dead.reroutes)
        {
        	i++;
        	x =(int) ((x+posX)/2);
        	y =(int) ((y+posY)/2);
        	z =(int) ((z+posZ)/2);
        	pathToEntity = worldObj.getEntityPathToXYZ(this, x, y, z, mod_Mine4Dead.pathComplexity);
        }
        if (pathToEntity==null && ticksExisted>150)
        {
        	//System.out.println("Sorry, i'm too stupid to find a way over to the shrine and will now teleport myself closer.");
        	teleportCloserToShrine();
        }
    }
    
    public void teleportCloserToShrine()
    {
    	spawnExplosionParticle();
    	posX = (((double)mod_Mine4Dead.shrine.xCoord)+posX+posX)/3F;
    	posY = (((double)mod_Mine4Dead.shrine.yCoord)+posY+posY)/3F;
    	posZ = (((double)mod_Mine4Dead.shrine.zCoord)+posZ+posZ)/3F;
    	moveEntity(posX,posY,posZ);
    	spawnExplosionParticle();
    }
    
    public EntityM4DMob following = null;
    public int followMe(EntityM4DMob leader)
    {
    	if (playerToAttack==null)
    	{
    		following=leader;
    		return value;
    	}
    	return 0;
    }
    
    private double oldposX = posX;
    private double oldposY = posZ;
    private double oldposZ = posZ;
    private int oldtimer = 0;
    protected void updatePlayerActionState()
    {
    	
    	if (stunned>0)
    	{
    		stunned--;
    		pathToEntity=null;
    		playerToAttack=null;
    		if (ticksExisted%20==0)
    		{
    			 double d = worldObj.rand.nextGaussian() * 0.02D;
 	            double d1 = worldObj.rand.nextGaussian() * 0.02D;
 	            double d2 = worldObj.rand.nextGaussian() * 0.02D;
 	            worldObj.spawnParticle("smoke", (posX + (double)(worldObj.rand.nextFloat() * width * 2.0F)) - (double)width, posY + 0.5D + (double)(worldObj.rand.nextFloat() * height), (posZ + (double)(worldObj.rand.nextFloat() * width * 2.0F)) - (double)width, d, d1, d2);
    		}
    		return;
    	}
    	
    	if (mod_Mine4Dead.shrine == null)
    	{
    		setEntityDead();
    		return;
    	}
        hasAttacked = func_25026_u();
        float f = mod_Mine4Dead.pathComplexity;
        if (pathToEntity==null)
        {
        	getNewPath();
        }
        if (playerToAttack!=null)
        {
        	attackEntity(playerToAttack, playerToAttack.getDistanceToEntity(this));
        }
        oldtimer++;
        if (oldtimer>=100)
        {
        	oldtimer=0;
        	if (Math.abs(oldposX-posX)+Math.abs(oldposY-posY)+Math.abs(oldposZ-posZ)<=10)
        	{
        		teleportCloserToShrine();
        		System.out.println("Unstucking M4DMob");
        	}
        }
        if(!hasAttacked && playerToAttack != null && (pathToEntity == null || rand.nextInt(20) == 0))
        {
            pathToEntity = worldObj.getPathToEntity(this, playerToAttack, f);
        } else
        if(!hasAttacked && (pathToEntity == null && rand.nextInt(80) == 0 || rand.nextInt(80) == 0))
        {
        	func_31021_B();
        }
        int i = MathHelper.floor_double(boundingBox.minY + 0.5D);
        boolean flag = isInWater();
        boolean flag1 = handleLavaMovement();
        rotationPitch = 0.0F;
        if(pathToEntity == null || rand.nextInt(100) == 0)
        {
            super.updatePlayerActionState();
            pathToEntity = null;
            return;
        }
        Vec3D vec3d = pathToEntity.getPosition(this);
        for(double d = width * 2.0F; vec3d != null && vec3d.squareDistanceTo(posX, vec3d.yCoord, posZ) < d * d;)
        {
            pathToEntity.incrementPathIndex();
            if(pathToEntity.isFinished())
            {
                vec3d = null;
                pathToEntity = null;
            } else
            {
                vec3d = pathToEntity.getPosition(this);
            }
        }

        isJumping = false;
        if(vec3d != null)
        {
            double d1 = vec3d.xCoord - posX;
            double d2 = vec3d.zCoord - posZ;
            double d3 = vec3d.yCoord - (double)i;
            float f2 = (float)((Math.atan2(d2, d1) * 180D) / 3.1415927410125732D) - 90F;
            float f3 = f2 - rotationYaw;
            moveForward = moveSpeed;
            for(; f3 < -180F; f3 += 360F) { }
            for(; f3 >= 180F; f3 -= 360F) { }
            if(f3 > 30F)
            {
                f3 = 30F;
            }
            if(f3 < -30F)
            {
                f3 = -30F;
            }
            rotationYaw += f3;
            if(hasAttacked && playerToAttack != null)
            {
                double d4 = playerToAttack.posX - posX;
                double d5 = playerToAttack.posZ - posZ;
                float f5 = rotationYaw;
                rotationYaw = (float)((Math.atan2(d5, d4) * 180D) / 3.1415927410125732D) - 90F;
                float f4 = (((f5 - rotationYaw) + 90F) * 3.141593F) / 180F;
                moveStrafing = -MathHelper.sin(f4) * moveForward;
                moveForward = MathHelper.cos(f4) * moveForward;
            }
            if(d3 > 0.0D)
            {
                isJumping = true;
            }
        }
        if(playerToAttack != null)
        {
            faceEntity(playerToAttack, 30F, 30F);
        }
        if(isCollidedHorizontally && !getGotPath())
        {
            isJumping = true;
        }
        if(rand.nextFloat() < 0.8F && (flag || flag1))
        {
            isJumping = true;
        }
    }

    protected float getBlockPathWeight(int i, int j, int k)
    {
        return 0.5F + worldObj.getLightBrightness(i, j, k);
    }

    public void writeEntityToNBT(NBTTagCompound nbttagcompound)
    {
        super.writeEntityToNBT(nbttagcompound);
    }

    public void readEntityFromNBT(NBTTagCompound nbttagcompound)
    {
        super.readEntityFromNBT(nbttagcompound);
    }

    public boolean getCanSpawnHere()
    {
        int i = MathHelper.floor_double(posX);
        int j = MathHelper.floor_double(boundingBox.minY);
        int k = MathHelper.floor_double(posZ);
        if(worldObj.getSavedLightValue(EnumSkyBlock.Sky, i, j, k) > rand.nextInt(32))
        {
            return false;
        }
        int l = worldObj.getBlockLightValue(i, j, k);
        if(worldObj.func_27067_u())
        {
            int i1 = worldObj.skylightSubtracted;
            worldObj.skylightSubtracted = 10;
            l = worldObj.getBlockLightValue(i, j, k);
            worldObj.skylightSubtracted = i1;
        }
        return l <= rand.nextInt(8) && super.getCanSpawnHere();
    }
    
    protected int getDropItemId()
    {
        return mod_Mine4Dead.darkEnergy.shiftedIndex;
    }
    
    protected void dropFewItems()
    {
    	if (value<=0)
    	{
    		return;
    	}
        int j = worldObj.rand.nextInt(value+1);
        for(int k = 0; k < j; k++)
        {
        	if (j-k>=8)
        	{
        		k+=8;
        		dropItem(mod_Mine4Dead.darkDiamond.shiftedIndex, 1);
        	}
        	else
        	{
        		 dropItem(mod_Mine4Dead.darkEnergy.shiftedIndex, 1);
        	}
        }
    }
    
    protected boolean canDespawn()
    {
        return false;
    }
    
    public boolean corrupt()
    {
    	return corrupt(10);
    }
    
    public void causeKnockbackTo(EntityLiving target, int power)
    {
    	double d = posX - target.posX;
        double d1;
        for(d1 = posZ - target.posZ; d * d + d1 * d1 < 0.0001D; d1 = (Math.random() - Math.random()) * 0.01D)
        {
            d = (Math.random() - Math.random()) * 0.01D;
        }

        target.attackedAtYaw = (float)((Math.atan2(d1, d) * 180D) / 3.1415927410125732D) - target.rotationYaw;
        target.knockBack(this, power, d, d1);
    }
    
    public void gatherFollowers()
    {
    	if (followerAmount < followerLimit)
    	{
    		AxisAlignedBB boundingBox = AxisAlignedBB.getBoundingBox(0.0D, 0.0D, 0.0D, 0.0D, 0.0D, 0.0D);
        	List list1 = worldObj.getEntitiesWithinAABBExcludingEntity(this, boundingBox.addCoord(posX, posY, posZ).expand(8.0D, 8.0D, 8.0D));
        	for (int i = 0; i < list1.size() && followerAmount < 20; i++)
        	{
        		//System.out.println("Looking for companion");
        		if (list1.get(i) instanceof EntityM4DMob)
        		{
        			followerAmount+=((EntityM4DMob)list1.get(i)).followMe(this);
        		}
        	}
    	}
    }
    
    public boolean corrupt(int power)
    {
    	if (worldObj.rand.nextInt(power+1)>=value)
    	{
	        for(int i = 0; i < 7; i++)
	        {
	            double d = worldObj.rand.nextGaussian() * 0.02D;
	            double d1 = worldObj.rand.nextGaussian() * 0.02D;
	            double d2 = worldObj.rand.nextGaussian() * 0.02D;
	            worldObj.spawnParticle("heart", (posX + (double)(worldObj.rand.nextFloat() * width * 2.0F)) - (double)width, posY + 0.5D + (double)(worldObj.rand.nextFloat() * height), (posZ + (double)(worldObj.rand.nextFloat() * width * 2.0F)) - (double)width, d, d1, d2);
	        }
	        corrupted=true;
	        playerToAttack=findPlayerToAttack();
	        return true;
    	}
    	return false;
    }
    
    public void chant()
    {
    	if (!corrupt(4))
    	{
    		if (worldObj.rand.nextInt(11)>=value)
    		{
    			stun(100+worldObj.rand.nextInt(101)+worldObj.rand.nextInt(201));
    		}
    	}
    }
    
    public void stun(int power)
    {
    	spawnExplosionParticle();
    	stunned=power;
    	pathToEntity=null;
    	playerToAttack=null;
    }
    
    public void trap(int duration)
    {
    	if (100*duration>trapped)
		{
    		trapped=100*duration;
		}
    	trapX=posX;
    	trapZ=posZ;
    }
    
    public MovingObjectPosition rayTrace(double d, float f)
    {
        Vec3D vec3d = getPosition(f);
        Vec3D vec3d1 = getLook(f);
        Vec3D vec3d2 = vec3d.addVector(vec3d1.xCoord * d, vec3d1.yCoord * d, vec3d1.zCoord * d);
        return worldObj.rayTraceBlocks(vec3d, vec3d2);
    }
    
    public Vec3D getPosition(float f)
    {
        if(f == 1.0F)
        {
            return Vec3D.createVector(posX, posY, posZ);
        } else
        {
            double d = prevPosX + (posX - prevPosX) * (double)f;
            double d1 = prevPosY + (posY - prevPosY) * (double)f;
            double d2 = prevPosZ + (posZ - prevPosZ) * (double)f;
            return Vec3D.createVector(d, d1, d2);
        }
    }
    
    public int value = 0;
    protected int attackStrength;
    protected int attackInterval = 20;
    protected float mobSpeed = 1.0F;
    protected double jumpPower = 1D;
    protected int maxHealth;
    protected float mobRange = 2F;
    public boolean corrupted = false;
    public int stunned = 0;
    public double trapX =-42D;
    public double trapZ =-42D;
    public int trapped = 0;
    public int followerAmount = 0;
    public int followerLimit = 0;
}
